clear all

* Set Folder to input one

cd ..\Inputs

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "CBO Real Potential GDP.xls", ///
sheet(Vintages) cellrange(A1) firstrow clear

* Generate date variables and rearrange

rename observation_date date
gen year=year(date)
gen quarter=quarter(date)
gen month=month(date)
gen yearsem=.
replace yearsem=year*10+1 if month==1
replace yearsem=year*10+2 if month==7
drop if year<1960
egen tt=group(date)
order date tt year quarter month yearsem

* Label variables according to a dummy to later reuse this variable

local i=0
foreach v of varlist GDPPOT* {
	local timep=substr(`"`v'"',8,6)
	label var `v' "`timep'"
	rename `v' POT`i'
	local ++i
}

* Set time series to be able to use lag and difference operators

tsset tt

* Generate growth rates

foreach v of varlist POT* {
	gen GR`v'=(`v'-L.`v')/L.`v'*400
}

* Generate revision of growth rates for the same year and quarter across two 
* consecutive vintages of CBO data

forvalues r=1/43 {
	gen r1evs`r'=GRPOT`r'-GRPOT`=`r'-1'
}

forvalues r=2/43 {
	gen r2evs`r'=GRPOT`=`r'-1'-GRPOT`=`r'-2'
}

* Rename growth rates and revisions to incorporate date

foreach v of varlist GRPOT* r?evs* {
	local name=substr(`"`v'"',1,5)
	local numb=substr(`"`v'"',6,2)
	local time : variable label POT`numb'
	rename `v' `name'`time'
}

foreach v of varlist GRPOT* r?evs* {
	local name =substr(`"`v'"',1,5)
	local yeart=substr(`"`v'"',6,4)
	local month=substr(`"`v'"',10,2)
	if "`month'"=="01" local sem=1
	if "`month'"=="02" local sem=1
	if "`month'"=="03" local sem=1
	if "`month'"=="04" local sem=1
	if "`month'"=="05" local sem=1
	if "`month'"=="06" local sem=1
	if "`month'"=="07" local sem=2
	if "`month'"=="08" local sem=2
	if "`month'"=="09" local sem=2
	if "`month'"=="10" local sem=2
	if "`month'"=="11" local sem=2
	if "`month'"=="12" local sem=2
	rename `v' `name'`yeart'`sem'
}

gen GRPOTm5=.
gen GRPOTm4=.
gen GRPOTm3=.
gen GRPOTm2=.
gen GRPOTm1=.
gen GRPOT=.
gen GRPOT1=.
gen GRPOT2=.
gen GRPOT3=.
gen GRPOT4=.
gen GRPOT5=.

forvalues i=0/5 {
	forvalues l=1/2 {
		gen r`l'ev`i'=.
	}
}

forvalues year=1991(1)2017 {
	forvalues semes=1(1)2 {
		capture {
			replace GRPOTm5=L20.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOTm4=L16.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOTm3=L12.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOTm2=L8.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOTm1=L4.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT=GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT1=F4.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT2=F8.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT3=F12.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT4=F16.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
			replace GRPOT5=F20.GRPOT`year'`semes' if yearsem==`=`year'*10+`semes''
		}
		forvalues i=0/5 {
			forvalues l=1/2 {
				capture replace r`l'ev`i'=F`i'.r`l'evs`year'`semes' if yearsem==`=`year'*10+`semes''
			}
		}	
	}
}

* Keep only available observarions and generate semester

keep if GRPOT!=.
gen semester=mod(yearsem,10)

* Keep only relevant variables and rename

keep  year semester quarter month GRPOT GRPOT? GRPOT?? r?ev?
order year semester quarter month GRPOT GRPOT? GRPOT?? r?ev?

rename GRPOTm5 gRpotm5y
rename GRPOTm4 gRpotm4y
rename GRPOTm3 gRpotm3y
rename GRPOTm2 gRpotm2y
rename GRPOTm1 gRpotm1y
rename GRPOT   gRpot0
rename GRPOT1  gRpot1y
rename GRPOT2  gRpot2y
rename GRPOT3  gRpot3y
rename GRPOT4  gRpot4y
rename GRPOT5  gRpot5y

rename r1ev? revRpot?
rename r2ev? rev2Rpot?

egen sumRpot=rowmean(revRpot*)
egen sum1Rpot4=rowmean(revRpot0 revRpot1 revRpot2 revRpot3)
egen sum2Rpot4=rowmean(rev2Rpot0 rev2Rpot1 rev2Rpot2 rev2Rpot3)

drop semester month

* Rename variables

ds year quarter, not
foreach var of varlist `r(varlist)' {
	rename `var' CBO`var'
}

* Change to output folder and save

cd ..\Outputs
save Data_CBO, replace
